﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using ClassLibrary;

namespace AddressBookTesting
{
    [TestClass]
    public class tstCounty
    {
        [TestMethod]
        public void InstantiationOk()
        {
            //create an instance of the class
            clsCounty ACounty = new clsCounty();
        }

        [TestMethod]
        //used to test the County property of the class
        public void County()
        {
            //create an instance of the class
            clsCounty ACounty = new clsCounty();
            //create a variable to store the name of a county
            string SomeCounty;
            //assign a county to the variable
            SomeCounty = "Leicestershire";
            //try to send some data to the County property
            ACounty.County = SomeCounty;
            //check to see that the data in the variable and the property are the same
            Assert.AreEqual(ACounty.County, SomeCounty);
        }

        [TestMethod]
        //used to test the CountyNo property of the class
        public void CountyNo()
        {
            //create an instance of the class
            clsCounty ACounty = new clsCounty();
            //create a variable to store the Id of a County
            Int32 CountyNo;
            //assign a value to the variable
            CountyNo = 123;
            //try to send some data to the CountyNo property
            ACounty.CountyNo = CountyNo;
            //check to see that the data in the variable and the property are the same
            Assert.AreEqual(ACounty.CountyNo, CountyNo);
        }

        [TestMethod]
        //used to test the presence of the Valid Method
        public void Valid()
        { 
            //create an instance of the class
            clsCounty ACounty = new clsCounty();
            //test to see if the valid method exists
            ACounty.Valid("Leicestershire");
        }

        [TestMethod]
        //test that the county validation throws an error when county is blank
        public void CountyMinLessOne()
        { 
            //create an instance of the class
            clsCounty ACounty = new clsCounty();
            //create a variable to record the result of the validation test
            Boolean OK;
            //test the valid method with a blank string
            OK = ACounty.Valid("");
            //assert that the outcome should be false
            Assert.IsFalse(OK);
        }

        [TestMethod]
        public void CountyMaxPlusOne()
        {
            //create an instance of the class
            clsCounty ACounty = new clsCounty();
            //create a variable to record the result of the validation test
            Boolean OK;
            //create a variable to store the test data
            string SomeText = "";
            //pad the data to the required number of characters
            SomeText = SomeText.PadLeft(21);
            //test the valid method with a two character string
            OK = ACounty.Valid(SomeText);
            //assert that the outcome should be true
            Assert.IsFalse(OK);
        }
        
    }
}
